 SELECT tsystem.function__drop_by_regex('abk__termination_group_execute', 'scheduling', true, true);
 CREATE OR REPLACE FUNCTION scheduling.abk__termination_group_execute(
     IN  _ab_ix                                    integer,
         -- Mittelpunktterminierung, ab diesem AG (Vorwärts / Rückwärts). Standard: NULL (vorwärts/rückwärts alles)
     IN  _date_start                               timestamp,
         -- Ergbnis nur als Vorschau? -> Rückgabe der Funktion
     IN  _write_to_disk                            bool    DEFAULT false,-- NOT NULL,
         -- Terminierungsrichtung / Art
     IN  _forward__backward                        varchar DEFAULT NULL,
         -- Zeitfenster
     IN  _range_years                              numeric DEFAULT 1,
         -- Wenn Rückwärtsterminierung in Vergangenheit kommt, dann automatisch Vorwärtsterminerung
     IN  _AutoForwardOnPast                        bool    DEFAULT true,
     IN  _current_date                             timestamp    DEFAULT now(),
     IN  _dlz_terminiation                         bool    DEFAULT false,
         -- wenn bereits einterminiert, dann diese Resource erhalten!
     IN  _resource_id_main_fix__clear              bool    DEFAULT false,

     IN  _stack_depth                              int     DEFAULT 0,

     IN  _loglevel                                 int     DEFAULT TSystem.Log_Get_LogLevel( _user => 'yes' ),

     OUT ti_resource_id                            integer,
     OUT ti_a2_id                                  integer,
     OUT ti_date_start                             timestamp without time zone,
     OUT ti_date_end                               timestamp without time zone,
     OUT slotfactor                                numeric,
     OUT ti_type                                   scheduling.resource_timeline_blocktype,
     -- true, wenn timeslot hier durch terminierung erstellt wurde. false, wenn bestehender timeslot (zB nur AG 50 terminieren, dennoch werden die anderen AG mit ausgegeben, siehe "IF termination_successfull THEN ")
     OUT timeslot_terminated                       bool
     )
     RETURNS SETOF record
     AS $$
     DECLARE
         _timeframe_start                             timestamp without time zone;
         _timeframe_end                               timestamp without time zone;
         _packing                                     bool;
         r                                            record;
     BEGIN
        RAISE NOTICE '%', format(
            $call$
                      call: scheduling.abk__termination_group_execute(
                            _ab_ix => %L,
                            _date_start => %L,
                            _write_to_disk => %L,
                            _forward__backward => %L,
                            _range_years => %L,
                            _AutoForwardOnPast => %L,
                            _current_date => %L,
                            _dlz_terminiation => %L,
                            _resource_id_main_fix__clear => %L,
                            _stack_depth => %L,
                            _loglevel => %L
                      )
            $call$,
            _ab_ix, _date_start, _write_to_disk,
            _forward__backward, _range_years, _AutoForwardOnPast,
            _current_date,
            _dlz_terminiation, _resource_id_main_fix__clear, _stack_depth,
            _loglevel
        );

         -- Anhand Richtung die Terminierungsfunktion richtige Datumsgrenzen
         -- ACHTUNG auch in:abk__termination_execute__auto
         -- Rückwärts: Beginnt am Ende. Max bis heute.
         IF _forward__backward  = 'backward' THEN
            _timeframe_start                          := greatest(_current_date, _date_start::date - round( _range_years * 365)::integer ); -- + frozen;
            _timeframe_end                            := _date_start;
         END IF;

         -- Vorwärts: Beginnt heute. Max bis Range.
         IF _forward__backward LIKE 'forward%' THEN
            _timeframe_start                          := greatest(_current_date, _date_start ) ; -- Beschaffungsfrist Material! -- TSystem.Settings__GetInteger('abk_term_sperrange_days') => Oberfläche?
            _timeframe_end                            := _timeframe_start::date + round( _range_years * 365)::integer;
            _packing                                  := _forward__backward = 'forward-pack';
            _forward__backward                        := 'forward';
         END IF;

         -- Terminieren
         RAISE NOTICE 'abk__termination_group_execute => scheduling.resource_timeline__abk_group__termination(
                                              _abk_ix                                 => %
                                             ,_timeframe_start                        => ''%''
                                             ,_timeframe_end                          => ''%''
                                             ,_write_to_disk                          => %
                                             ,_direction                              => ''%''
                                             ,_scenario                               => %
                                             ,_checkBlockedTimes                      => %
                                             ,_resource_id_main_fix__clear            => %
                                             ,_loglevel                               => %
                                             )

                                             _packing                                 => %

                                             '
                                                                                       -- siehe Block eins weiter unten = identisch
                                                                                       , _ab_ix
                                                                                       , _timeframe_start
                                                                                       , _timeframe_end
                                                                                       , _write_to_disk
                                                                                       , _forward__backward
                                                                                       , NULL
                                                                                       , NOT _dlz_terminiation
                                                                                       , _resource_id_main_fix__clear
                                                                                       , _loglevel
                                                                                       , _packing
                                                                                       ;

         -- wenn Vorwärts terminieren und Packen
         IF _packing IS true THEN
            -- frühesten Endezeitpunkt ermitteln
            _date_start :=       max(tfw.ti_date_end)
                            FROM scheduling.abk__termination_group_execute(
                                                        _ab_ix              => _ab_ix,
                                                        _date_start         => _date_start,
                                                        _write_to_disk      => false, --_write_to_disk,
                                                        _forward__backward  => 'forward',
                                                        _range_years        => _range_years,
                                                        _AutoForwardOnPast  => false,
                                                        _current_date       => _current_date,
                                                        _dlz_terminiation   => _dlz_terminiation,
                                                        _resource_id_main_fix__clear => _resource_id_main_fix__clear,

                                                        _stack_depth        => -1, -- wir fangen komplett von vorn an. Kennzeichen für Resource fixieren während vorwärts terminieren

                                                        _loglevel           => _loglevel
                                  ) AS tfw; -- termination for ward
            RAISE NOTICE 'packing result in : datestart for backward: %', _date_start;
            RETURN QUERY SELECT *
                            FROM scheduling.abk__termination_group_execute(
                                                        _ab_ix              => _ab_ix,
                                                        _date_start         => _date_start,
                                                        _write_to_disk      => _write_to_disk,
                                                        _forward__backward  => 'backward',
                                                        _range_years        => _range_years,
                                                        _AutoForwardOnPast  => false,
                                                        _current_date       => _current_date,
                                                        _dlz_terminiation   => _dlz_terminiation,
                                                        _resource_id_main_fix__clear => _resource_id_main_fix__clear,

                                                        _stack_depth        => 0, -- wir fangen komplett von vorn an.

                                                        _loglevel           => _loglevel
                                 );
            RETURN;
         END IF;


         RETURN QUERY
                         SELECT  __resource_id   AS ti_resource_id,
                                 __ab2_id        AS ti_a2_id,
                                 __slotstartdate AS ti_date_start,
                                 __slotenddate   AS ti_date_end,
                                 __slotfactor    AS slotfactor,
                                 __type          AS ti_type,
                                 true
                            FROM scheduling.resource_timeline__abk_group__termination(
                                      _abk_ix_root          => _ab_ix,

                                      _timeframe_start      => _timeframe_start,
                                      _timeframe_end        => _timeframe_end,

                                      _write_to_disk        => _write_to_disk,

                                      _direction            => _forward__backward,

                                      _checkBlockedTimes    => NOT _dlz_terminiation,

                                      _resource_id_main_fix__clear => _resource_id_main_fix__clear,

                                      _resource_id_main_fix__set   => _stack_depth = -1, -- Während Suche nach Enddatum auch Abrbeitsplatzressourcen fixieren. -1 ist bei Forwärts für Packen. Damit wird für das folgende Rückwärtsterminieren fixiert und keine Alternativen mehr!

                                      _loglevel             => _loglevel
                                 )
                         ;
     END $$ LANGUAGE plpgsql;